/*
 * Decompiled with CFR 0.152.
 */
package pngz;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class PNGz {
    private byte[] data;
    private String pass;
    private BufferedImage img;

    public PNGz(byte[] data) {
        this.data = data;
        this.img = null;
    }

    public PNGz(BufferedImage img) {
        this.img = img;
        this.data = null;
    }

    public BufferedImage pack(String pass) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, InvalidAlgorithmParameterException, BadPaddingException, IOException, NullPointerException, Exception, Error {
        this.setPass(pass);
        this.deflate(9);
        this.encrypt();
        this.deflate(1);
        this.encode();
        return this.img;
    }

    public BufferedImage pack() throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, InvalidAlgorithmParameterException, BadPaddingException, IOException, NullPointerException, Exception, Error {
        this.deflate(9);
        this.encode();
        return this.img;
    }

    public byte[] unpack(String pass) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, DataFormatException, IOException, NullPointerException, OutOfMemoryError, Exception, Error {
        this.setPass(pass);
        this.decode();
        this.inflate();
        this.decrypt();
        this.inflate();
        return this.data;
    }

    public byte[] unpack() throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, DataFormatException, IOException, NullPointerException, OutOfMemoryError, Exception, Error {
        this.decode();
        this.inflate();
        return this.data;
    }

    public void setPass(String pass) {
        this.pass = pass == null ? null : pass;
    }

    public void setPass() {
        this.pass = null;
    }

    public BufferedImage getImg() {
        return this.img;
    }

    public byte[] getData() {
        return this.data;
    }

    public void encode() throws NullPointerException, OutOfMemoryError, Exception, Error {
        int end;
        int i;
        int len = this.data.length;
        int w = (int)Math.ceil(Math.sqrt((double)len / 3.0));
        int h = (int)Math.max(Math.ceil((double)len / 3.0 / (double)w), 1.0);
        int max = w * h * 3;
        int[] px = new int[max];
        for (i = 0; i < len; ++i) {
            px[i] = this.data[i];
        }
        if (len % 3 == 2) {
            px[i] = (this.data[(i + 29) % len] + 37) % 256;
            ++i;
        } else if (len % 3 == 1) {
            px[i] = (this.data[(i + 23) % len] + 41) % 256;
            px[++i] = (this.data[(i + 29) % len] + 37) % 256;
            ++i;
        }
        for (i = end = i; i < max; i += 3) {
            px[i] = (this.data[(i + 19) % len] + 43) % 256;
            px[i + 1] = (this.data[(i + 23) % len] + 41) % 256;
            px[i + 2] = (this.data[(i + 29) % len] + 37) % 256;
        }
        this.data = null;
        this.img = new BufferedImage(w, h, 5);
        WritableRaster raster = (WritableRaster)this.img.getData();
        raster.setPixels(0, 0, w, h, px);
        px = null;
        this.img.setData(raster);
        raster = null;
    }

    public void decode() throws NullPointerException, OutOfMemoryError, Exception, Error {
        byte[] px = ((DataBufferByte)this.img.getRaster().getDataBuffer()).getData();
        int len = px.length;
        boolean a = this.img.getColorModel().hasAlpha();
        this.img = null;
        if (a) {
            int j = 0;
            int i = 0;
            while (i < len) {
                byte c = px[i + 1];
                px[j] = px[i + 3];
                px[j + 1] = px[i + 2];
                px[j + 2] = c;
                i += 4;
                j += 3;
            }
            this.data = PNGz.split(px, 0, len * 3 / 4);
        } else {
            for (int i = 0; i < len; i += 3) {
                byte c = px[i];
                px[i] = px[i + 2];
                px[i + 2] = c;
            }
            this.data = px;
        }
    }

    public void deflate(int level) throws IOException, NullPointerException, OutOfMemoryError, Exception, Error {
        Deflater d = new Deflater(level, true);
        d.setInput(this.data);
        ByteArrayOutputStream outStream = new ByteArrayOutputStream(this.data.length);
        d.finish();
        byte[] buffer = new byte[1024];
        while (!d.finished()) {
            int count = d.deflate(buffer);
            outStream.write(buffer, 0, count);
        }
        outStream.close();
        byte[] out = outStream.toByteArray();
        d.end();
        this.data = out;
    }

    public void inflate() throws DataFormatException, IOException, NullPointerException, OutOfMemoryError, Exception, Error {
        Inflater i = new Inflater(true);
        i.setInput(this.data);
        ByteArrayOutputStream outStream = new ByteArrayOutputStream(this.data.length);
        byte[] buffer = new byte[1024];
        while (!i.finished()) {
            int count = i.inflate(buffer);
            outStream.write(buffer, 0, count);
        }
        outStream.close();
        byte[] out = outStream.toByteArray();
        i.end();
        this.data = out;
    }

    public void encrypt() throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, InvalidAlgorithmParameterException, BadPaddingException, OutOfMemoryError, Exception, Error {
        Cipher c = Cipher.getInstance("AES/CBC/PKCS5Padding");
        SecureRandom rand = new SecureRandom();
        byte[] iv = new byte[16];
        rand.nextBytes(iv);
        IvParameterSpec ivSpec = new IvParameterSpec(iv);
        SecretKeySpec keySpec = new SecretKeySpec(PNGz.split(PNGz.sha1(PNGz.merge(this.pass.getBytes(), iv)), 0, 16), "AES");
        c.init(1, (Key)keySpec, ivSpec);
        this.data = PNGz.merge(iv, c.doFinal(PNGz.merge(this.data, "|".getBytes())));
    }

    public void decrypt() throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, OutOfMemoryError, Exception, Error {
        Cipher c = Cipher.getInstance("AES/CBC/PKCS5Padding");
        IvParameterSpec ivSpec = new IvParameterSpec(PNGz.split(this.data, 0, 16));
        byte[] ivByte = ivSpec.getIV();
        SecretKeySpec keySpec = new SecretKeySpec(PNGz.split(PNGz.sha1(PNGz.merge(this.pass.getBytes(), ivByte)), 0, 16), "AES");
        c.init(2, (Key)keySpec, ivSpec);
        this.data = PNGz.unpad(c.doFinal(PNGz.split(this.data, 16, this.data.length)), "|".getBytes()[0]);
    }

    private static byte[] sha1(byte[] data) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA1");
        md.update(data);
        return new BigInteger(1, md.digest()).toString(16).getBytes();
    }

    private static byte[] merge(byte[] a, byte[] b) {
        byte[] out = new byte[a.length + b.length];
        System.arraycopy(a, 0, out, 0, a.length);
        System.arraycopy(b, 0, out, a.length, b.length);
        return out;
    }

    private static byte[] split(byte[] a, int start, int finish) {
        byte[] out = new byte[finish - start];
        System.arraycopy(a, start, out, 0, finish - start);
        return out;
    }

    private static byte[] unpad(byte[] a, byte ch) {
        for (int i = a.length - 1; i >= 0; --i) {
            if (a[i] != ch) continue;
            return PNGz.split(a, 0, i);
        }
        return a;
    }
}

