/*
 * Decompiled with CFR 0.152.
 */
package pngz;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.zip.DataFormatException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.SpringLayout;
import pngz.PNGz;

public class Interface
extends JFrame {
    private final SpringLayout layout;
    private Interface frame;
    private final JPanel panel;
    private final JButton to;
    private final JButton from;
    private final JLabel passLabel;
    private JPasswordField pass;
    private FileDialog toFile;
    private FileDialog fromFile;

    public static void main(String[] args) {
        Interface frame = new Interface(args);
    }

    private Interface(String[] args) {
        super("PNGz - Encoder/Decoder");
        this.setSize(320, 200);
        this.setResizable(false);
        this.setDefaultCloseOperation(3);
        this.setLocationRelativeTo(null);
        this.panel = new JPanel();
        this.layout = new SpringLayout();
        this.panel.setLayout(this.layout);
        this.toFile = new FileDialog((Frame)this, "Select a file to encode with PNGz...", 0);
        this.toFile.setLocationRelativeTo(null);
        this.toFile.setDirectory(System.getProperty("user.dir"));
        this.to = new JButton("Data > PNGz");
        this.to.setToolTipText("Click or drag a file here to encode.");
        this.to.setDropTarget(new DropTarget(){

            @Override
            public synchronized void drop(DropTargetDropEvent e) {
                try {
                    e.acceptDrop(1);
                    List files = (List)e.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                    for (File file : files) {
                        new Thread(new Process(file.getAbsolutePath(), new String(Interface.this.pass.getPassword()), true)).start();
                    }
                }
                catch (UnsupportedFlavorException | IOException ex) {
                    Interface.error("File read/write error.");
                }
            }
        });
        this.to.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Interface.this.toFile.setVisible(true);
                String file = Interface.this.toFile.getFile();
                if (file != null) {
                    new Thread(new Process(file, new String(Interface.this.pass.getPassword()), true)).start();
                }
            }
        });
        this.panel.add(this.to);
        this.layout.putConstraint("North", (Component)this.to, 0, "North", (Component)this.panel);
        this.layout.putConstraint("East", (Component)this.to, 0, "HorizontalCenter", (Component)this.panel);
        this.layout.putConstraint("South", (Component)this.to, -25, "South", (Component)this.panel);
        this.layout.putConstraint("West", (Component)this.to, 0, "West", (Component)this.panel);
        this.fromFile = new FileDialog((Frame)this, "Select a file to decode from PNGz...", 0);
        this.fromFile.setLocationRelativeTo(null);
        this.fromFile.setDirectory(System.getProperty("user.dir"));
        this.from = new JButton("PNGz > Data");
        this.from.setToolTipText("Click or drag a file here to decode.");
        this.from.setDropTarget(new DropTarget(){

            @Override
            public synchronized void drop(DropTargetDropEvent e) {
                try {
                    e.acceptDrop(1);
                    List files = (List)e.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                    for (File file : files) {
                        new Thread(new Process(file.getAbsolutePath(), new String(Interface.this.pass.getPassword()), false)).start();
                    }
                }
                catch (UnsupportedFlavorException | IOException ex) {
                    Interface.error("File read/write error.");
                }
            }
        });
        this.from.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Interface.this.fromFile.setVisible(true);
                String file = Interface.this.fromFile.getFile();
                if (file != null) {
                    new Thread(new Process(file, new String(Interface.this.pass.getPassword()), false)).start();
                }
            }
        });
        this.panel.add(this.from);
        this.layout.putConstraint("North", (Component)this.from, 0, "North", (Component)this.panel);
        this.layout.putConstraint("East", (Component)this.from, 0, "East", (Component)this.panel);
        this.layout.putConstraint("South", (Component)this.from, -25, "South", (Component)this.panel);
        this.layout.putConstraint("West", (Component)this.from, 0, "HorizontalCenter", (Component)this.panel);
        this.passLabel = new JLabel("Password (optional):");
        this.passLabel.setToolTipText("Set a password for encryption, or leave blank to disable.");
        this.panel.add(this.passLabel);
        this.layout.putConstraint("North", (Component)this.passLabel, -24, "South", (Component)this.panel);
        this.layout.putConstraint("South", (Component)this.passLabel, 0, "South", (Component)this.panel);
        this.layout.putConstraint("West", (Component)this.passLabel, 4, "West", (Component)this.panel);
        this.pass = new JPasswordField();
        this.pass.setToolTipText("Set a password for encryption, or leave blank to disable.");
        this.panel.add(this.pass);
        this.layout.putConstraint("North", (Component)this.pass, -24, "South", (Component)this.panel);
        this.layout.putConstraint("East", (Component)this.pass, 0, "East", (Component)this.panel);
        this.layout.putConstraint("South", (Component)this.pass, 0, "South", (Component)this.panel);
        this.layout.putConstraint("West", (Component)this.pass, 4, "East", (Component)this.passLabel);
        this.setVisible(true);
        this.add(this.panel);
    }

    private static void error(String msg) {
        JOptionPane.showMessageDialog(null, msg, "PNGz - Error", 0);
    }

    private static void info(String msg) {
        JOptionPane.showMessageDialog(null, msg, "PNGz - Message", 1);
    }

    private class Process
    extends JFrame
    implements Runnable {
        private final String file;
        private final String type;
        private final String pass;
        private final boolean method;
        private boolean stop;
        private final JPanel panel;
        private final JProgressBar progress;
        private PNGz in;

        private Process(String file, String pass, boolean method) {
            super("PNGz - " + (pass == null || pass.equals("") ? (method ? "En" : "De") + "cod" : (method ? "En" : "De") + "crypt") + "ing");
            this.stop = false;
            this.file = file;
            this.pass = pass.equals("") ? null : pass;
            this.method = method;
            this.type = method ? "En" : "De";
            this.setSize(320, 50);
            this.setResizable(false);
            this.setDefaultCloseOperation(2);
            this.setLocationRelativeTo(null);
            this.addWindowListener(new WindowListener(){

                @Override
                public void windowClosing(WindowEvent arg) {
                    Process.this.stop = true;
                    Interface.info("Operation canceled.");
                }

                @Override
                public void windowActivated(WindowEvent arg) {
                }

                @Override
                public void windowClosed(WindowEvent arg) {
                }

                @Override
                public void windowDeactivated(WindowEvent arg) {
                }

                @Override
                public void windowDeiconified(WindowEvent arg) {
                }

                @Override
                public void windowIconified(WindowEvent arg) {
                }

                @Override
                public void windowOpened(WindowEvent arg) {
                }
            });
            this.panel = new JPanel();
            this.panel.setLayout(new BorderLayout());
            this.progress = new JProgressBar(0, 100);
            this.progress.setIndeterminate(true);
            this.progress.setBorderPainted(true);
            this.progress.setStringPainted(true);
            this.progress.setString(file);
            this.panel.add(this.progress);
            this.add(this.panel);
        }

        @Override
        public void run() {
            if (!this.method && this.file.lastIndexOf(".") == -1) {
                Interface.error("Filename error (Could Not Strip Extension).");
                this.dispose();
            } else {
                try {
                    this.setVisible(true);
                    this.progress.setIndeterminate(false);
                    if (this.method) {
                        this.in = new PNGz(Files.readAllBytes(Paths.get(this.file, new String[0])));
                        if (this.pass == null) {
                            this.in.setPass();
                            this.progress.setValue(25);
                            if (this.stop) {
                                return;
                            }
                            this.in.deflate(9);
                            this.progress.setValue(50);
                            if (this.stop) {
                                return;
                            }
                            this.in.encode();
                            this.progress.setValue(75);
                            if (this.stop) {
                                return;
                            }
                        } else {
                            this.in.setPass(this.pass);
                            this.progress.setValue(16);
                            if (this.stop) {
                                return;
                            }
                            this.in.deflate(9);
                            this.progress.setValue(33);
                            if (this.stop) {
                                return;
                            }
                            this.in.encrypt();
                            this.progress.setValue(50);
                            if (this.stop) {
                                return;
                            }
                            this.in.deflate(1);
                            this.progress.setValue(67);
                            if (this.stop) {
                                return;
                            }
                            this.in.encode();
                            this.progress.setValue(83);
                            if (this.stop) {
                                return;
                            }
                        }
                        ImageIO.write((RenderedImage)this.in.getImg(), "png", new File(this.file + ".png"));
                    } else {
                        this.in = new PNGz(ImageIO.read(new File(this.file)));
                        if (this.pass == null) {
                            this.in.setPass();
                            this.progress.setValue(25);
                            if (this.stop) {
                                return;
                            }
                            this.in.decode();
                            this.progress.setValue(50);
                            if (this.stop) {
                                return;
                            }
                            this.in.inflate();
                            this.progress.setValue(75);
                            if (this.stop) {
                                return;
                            }
                        } else {
                            this.in.setPass(this.pass);
                            this.progress.setValue(16);
                            this.in.decode();
                            this.progress.setValue(33);
                            if (this.stop) {
                                return;
                            }
                            this.in.inflate();
                            this.progress.setValue(50);
                            if (this.stop) {
                                return;
                            }
                            this.in.decrypt();
                            this.progress.setValue(67);
                            if (this.stop) {
                                return;
                            }
                            this.in.inflate();
                            this.progress.setValue(83);
                            if (this.stop) {
                                return;
                            }
                        }
                        Files.write(Paths.get(this.file.substring(0, this.file.lastIndexOf(".")), new String[0]), this.in.getData(), new OpenOption[0]);
                    }
                    this.progress.setValue(100);
                    Interface.info("File " + this.type + (this.pass == null ? "cod" : "crypt") + "ed to: " + (this.method ? this.file + ".png" : this.file.substring(0, this.file.lastIndexOf("."))));
                }
                catch (IOException ex) {
                    Interface.error("File read/write error.");
                }
                catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException ex) {
                    Interface.error("Internal " + this.type + "cryption error (Invalid Algorithm).");
                }
                catch (NoSuchPaddingException ex) {
                    Interface.error("Internal " + this.type + "cryption error (Invalid Padding).");
                }
                catch (InvalidKeyException ex) {
                    Interface.error("Internal " + this.type + "cryption error (Invalid Key).");
                }
                catch (BadPaddingException | IllegalBlockSizeException ex) {
                    Interface.error("Bad password.");
                }
                catch (NullPointerException | DataFormatException ex) {
                    Interface.error(this.type + "coding error (Corrupt File).");
                }
                catch (OutOfMemoryError ex) {
                    Interface.error(this.type + "coding error (Out of Memory).");
                }
                catch (Error | Exception ex) {
                    Interface.error("An unknown error has occured.");
                }
                finally {
                    this.dispose();
                    this.in = null;
                }
            }
        }
    }
}

